/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.function.Supplier;
import org.elasticsearch.SpecialPermission;

public class PrivilegedCode {
    public static <R> R execute(final Supplier<R> supplier) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        return (R)AccessController.doPrivileged(new PrivilegedAction<R>(){

            @Override
            public R run() {
                return supplier.get();
            }
        });
    }

    public static void execute(final Runnable runnable) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                runnable.run();
                return null;
            }
        });
    }

    public static <R, E1 extends Exception> R execute(final PrivilegedSupplierThrowing1<R, E1> supplier, Class<E1> throws1) throws E1 {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return (R)AccessController.doPrivileged(new PrivilegedExceptionAction<R>(){

                @Override
                public R run() throws Exception {
                    return supplier.get();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (throws1.isAssignableFrom(e.getCause().getClass())) {
                throw (Exception)throws1.cast(e.getCause());
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    public static <R, E1 extends Exception, E2 extends Exception> R execute(final PrivilegedSupplierThrowing2<R, E1, E2> supplier, Class<E1> throws1, Class<E2> throws2) throws E1, E2 {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return (R)AccessController.doPrivileged(new PrivilegedExceptionAction<R>(){

                @Override
                public R run() throws Exception, Exception {
                    return supplier.get();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (throws1.isAssignableFrom(e.getCause().getClass())) {
                throw (Exception)throws1.cast(e.getCause());
            }
            if (throws2.isAssignableFrom(e.getCause().getClass())) {
                throw (Exception)throws2.cast(e.getCause());
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    public static <R, E1 extends Exception, E2 extends Exception, E3 extends Exception> R execute(final PrivilegedSupplierThrowing3<R, E1, E2, E3> supplier, Class<E1> throws1, Class<E2> throws2, Class<E3> throws3) throws E1, E2, E3 {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return (R)AccessController.doPrivileged(new PrivilegedExceptionAction<R>(){

                @Override
                public R run() throws Exception, Exception, Exception {
                    return supplier.get();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (throws1.isAssignableFrom(e.getCause().getClass())) {
                throw (Exception)throws1.cast(e.getCause());
            }
            if (throws2.isAssignableFrom(e.getCause().getClass())) {
                throw (Exception)throws2.cast(e.getCause());
            }
            if (throws3.isAssignableFrom(e.getCause().getClass())) {
                throw (Exception)throws3.cast(e.getCause());
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    public static <E1 extends Exception> void execute(final PrivilegedProcedureThrowing1<E1> procedure, Class<E1> throws1) throws E1 {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    procedure.run();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (throws1.isAssignableFrom(e.getCause().getClass())) {
                throw (Exception)throws1.cast(e.getCause());
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    public static interface PrivilegedProcedureThrowing1<E1 extends Exception> {
        public void run() throws E1;
    }

    @FunctionalInterface
    public static interface PrivilegedSupplierThrowing3<R, E1 extends Exception, E2 extends Exception, E3 extends Exception> {
        public R get() throws E1, E2, E3;
    }

    @FunctionalInterface
    public static interface PrivilegedSupplierThrowing2<R, E1 extends Exception, E2 extends Exception> {
        public R get() throws E1, E2;
    }

    @FunctionalInterface
    public static interface PrivilegedSupplierThrowing1<R, E1 extends Exception> {
        public R get() throws E1;
    }
}

